<?php
/**
 * Class that operate on table 'faida'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-09-12 16:50
 */
class FaidaMySqlDAO implements FaidaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return FaidaMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM faida WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM faida';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM faida ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param faida primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM faida WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param FaidaMySql faida
 	 */
	public function insert($faida){
		$sql = 'INSERT INTO faida (client_id, premmium, comment ,user_id ,store_id,conditions,installment_duration,total_amount,presenter) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($faida->clientId);
		$sqlQuery->setNumber($faida->premmium);
		$sqlQuery->setString2($faida->comment);
		$sqlQuery->setNumber($faida->user_id);
        $sqlQuery->setNumber($faida->storeId);
        $sqlQuery->setNumber($faida->conditions);
        $sqlQuery->setNumber($faida->installment_duration);
        $sqlQuery->setNumber($faida->total_amount);
        $sqlQuery->setNumber($faida->presenter);

        $id = $this->executeInsert($sqlQuery);
		$faida->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param FaidaMySql faida
 	 */
	public function update($faida){
		$sql = 'UPDATE faida SET client_id = ? , premmium = ?, comment = ?, user_id = ? ,store_id = ?,conditions = ?,installment_duration = ?,total_amount = ?,presenter = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($faida->clientId);
		$sqlQuery->set($faida->premmium);
		$sqlQuery->setString2($faida->comment);
		$sqlQuery->setNumber($faida->user_id);
        $sqlQuery->setNumber($faida->storeId);
        $sqlQuery->setNumber($faida->conditions);
        $sqlQuery->setNumber($faida->installment_duration);
        $sqlQuery->setNumber($faida->total_amount);
        $sqlQuery->setNumber($faida->presenter);
		$sqlQuery->setNumber($faida->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM faida';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM faida WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductId($value){
		$sql = 'SELECT * FROM faida WHERE product_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPremmium($value){
		$sql = 'SELECT * FROM faida WHERE premmium = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM faida WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientId($value){
		$sql = 'DELETE FROM faida WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductId($value){
		$sql = 'DELETE FROM faida WHERE product_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPremmium($value){
		$sql = 'DELETE FROM faida WHERE premmium = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM faida WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return FaidaMySql 
	 */
	protected function readRow($row){
		$faida = new Faida();
		
		$faida->id = $row['id'];
		$faida->clientId = $row['client_id'];
		$faida->premmium = $row['premmium'];
		$faida->comment = $row['comment'];
		$faida->user_id = $row['user_id'];
		$faida->storeId = $row['store_id'];
		$faida->clientname = $row['clientname'];
		$faida->username = $row['username'];
		$faida->storeName = $row['storeName'];
		$faida->conditions = $row['conditions'];
		$faida->installment_duration = $row['installment_duration'];
		$faida->total_amount = $row['total_amount'];
		$faida->presenter = $row['presenter'];


		return $faida;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return FaidaMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>